/*
 * Decompiled with CFR 0.152.
 */
package de.filth.service;

import de.filth.domain.Images;
import de.filth.domain.ScoringResult;
import de.filth.service.ScoringService;
import de.filth.service.SettingsService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.net.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class PictureService {
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private ScoringService scoringService;
    @Autowired
    private Environment env;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private String tmpDir = System.getProperty("java.io.tmpdir");
    private String camFile = this.tmpDir + File.separator + "screen.png";
    private final Boolean isWindows;

    public PictureService() {
        String os = SystemUtils.OS_NAME;
        this.isWindows = os.toLowerCase(Locale.ROOT).contains("windows");
    }

    @PostConstruct
    public void storeImage() {
        new Thread(() -> {
            try {
                while (true) {
                    Object command = "";
                    if (this.settingsService.getSettings().getRtspPath() == null) {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                        continue;
                    }
                    String rtspPath = this.settingsService.getSettings().getRtspPath();
                    if (this.env.getActiveProfiles().length > 0 && this.env.getActiveProfiles()[0].equalsIgnoreCase("dev") && this.isWindows.booleanValue()) {
                        command = "build" + File.separator + "ffmpeg" + File.separator + "ffmpeg.exe -y -i " + rtspPath + " -vframes 1 " + this.camFile;
                    } else if (this.isWindows.booleanValue()) {
                        command = "ffmpeg" + File.separator + "ffmpeg.exe -y -i " + rtspPath + " -vframes 1 " + this.camFile;
                    }
                    Process process = Runtime.getRuntime().exec((String)command);
                    process.waitFor();
                    BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    String s = null;
                    while ((s = stdInput.readLine()) != null) {
                        if (!s.toLowerCase().contains("error")) continue;
                        this.LOG.error("ffmpeg error {}", (Object)s);
                    }
                    while ((s = stdError.readLine()) != null) {
                        if (!s.toLowerCase().contains("error")) continue;
                        this.LOG.error("ffmpeg error {}", (Object)s);
                    }
                    Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).start();
    }

    public byte[] getUnprocessedImage() throws IOException {
        File file = new File(this.camFile);
        if (!file.exists()) {
            return new byte[0];
        }
        return Files.readAllBytes(file.toPath());
    }

    public Images getBase64ProcessedImages() throws IOException {
        Images images = new Images();
        if (this.settingsService.getSettings().getRtspPath() == null) {
            return images;
        }
        Base64 base64 = new Base64();
        byte[] bytes = this.getUnprocessedImage();
        if (bytes.length == 0) {
            return images;
        }
        ScoringResult scoringResult = this.scoringService.getScoringResult(bytes);
        String encodedRaw = new String(base64.encode(scoringResult.getImage()));
        String encodedAbstract = new String(base64.encode(scoringResult.getAbstractImage()));
        images.setRawImage("data:image/png;base64, " + encodedRaw);
        images.setAbstractImage("data:image/png;base64, " + encodedAbstract);
        return images;
    }
}

