/*
 * Decompiled with CFR 0.152.
 */
package de.filth.controller;

import com.google.gson.Gson;
import de.filth.domain.Settings;
import de.filth.domain.SettingsEvent;
import de.filth.service.PictureService;
import de.filth.service.SettingsService;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.util.Base64;
import org.opencv.core.Point;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SettingsController {
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private PictureService pictureService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @RequestMapping(value={"/settings"}, method={RequestMethod.POST})
    public ResponseEntity changeSettings(HttpServletRequest request) throws IOException {
        String rtsp;
        String center;
        String crop;
        String diameterS;
        String hstretchS;
        String vstretchS;
        String sharpenS;
        String brightnessS = request.getParameter("brightness");
        if (StringUtils.isNotEmpty((CharSequence)brightnessS)) {
            Integer brightness = Integer.valueOf(brightnessS);
            this.settingsService.setBrightness(brightness);
        }
        if (StringUtils.isNotEmpty((CharSequence)(sharpenS = request.getParameter("sharpen")))) {
            Float sharpen = Float.valueOf(sharpenS);
            this.settingsService.setSharpen(sharpen);
        }
        if (StringUtils.isNotEmpty((CharSequence)(vstretchS = request.getParameter("vstretch")))) {
            Float vStretch = Float.valueOf(vstretchS);
            this.settingsService.setvStretch(vStretch);
        }
        if (StringUtils.isNotEmpty((CharSequence)(hstretchS = request.getParameter("hstretch")))) {
            Float hStretch = Float.valueOf(hstretchS);
            this.settingsService.sethStretch(hStretch);
        }
        if (StringUtils.isNotEmpty((CharSequence)(diameterS = request.getParameter("diameter")))) {
            Float diameter = Float.valueOf(diameterS);
            this.settingsService.setDiameter(diameter);
        }
        if (StringUtils.isNotEmpty((CharSequence)(crop = request.getParameter("crop")))) {
            crop = crop.replace("[", "").replace("]", "");
            String[] split = crop.split(",");
            ArrayList<Point> points = new ArrayList<Point>();
            for (int i = 0; i < 7; i += 2) {
                Point point = new Point(Double.parseDouble(split[i]), Double.parseDouble(split[i + 1]));
                points.add(point);
            }
            this.settingsService.setCrop(points);
        }
        if (StringUtils.isNotEmpty((CharSequence)(center = request.getParameter("center")))) {
            center = center.replace("[", "").replace("]", "");
            String[] split = center.split(",");
            Point point = new Point(Double.parseDouble(split[0]), Double.parseDouble(split[1]));
            this.settingsService.setCenter(point);
        }
        if (StringUtils.isNotEmpty((CharSequence)(rtsp = request.getParameter("rtsp")))) {
            this.settingsService.setRtsp(rtsp);
        }
        String settings = new Gson().toJson((Object)this.settingsService.getSettings());
        FileWriter myWriter = new FileWriter("settings.json");
        myWriter.write(settings);
        myWriter.close();
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SettingsEvent((Object)this));
        return new ResponseEntity((Object)this.pictureService.getBase64ProcessedImages().getRawImage(), HttpStatus.OK);
    }

    @RequestMapping(value={"/settings/target"}, method={RequestMethod.GET})
    public ModelAndView setupTarget(ModelMap model) throws IOException {
        byte[] bytes = this.pictureService.getUnprocessedImage();
        Base64 base64 = new Base64();
        String encodedString = new String(base64.encode(bytes));
        Settings settings = this.settingsService.getSettings();
        String base64img = "data:image/png;base64, " + encodedString;
        model.addAttribute("img", (Object)base64img);
        model.addAttribute("settings", (Object)settings);
        return new ModelAndView("target_setup", (Map)model);
    }
}

