/*
 * Decompiled with CFR 0.152.
 */
package de.filth.service;

import com.google.gson.Gson;
import de.filth.domain.Settings;
import de.filth.domain.SettingsEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;
import org.opencv.core.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
public class SettingsService {
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private Settings settings = new Settings();

    @EventListener(value={ApplicationReadyEvent.class})
    public void init() throws IOException {
        File file = new File("settings.json");
        if (!file.exists()) {
            return;
        }
        byte[] bytes = Files.readAllBytes(file.toPath());
        String content = new String(bytes);
        this.settings = (Settings)new Gson().fromJson(content, Settings.class);
        this.LOG.info("Loaded settings {}", (Object)this.settings);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new SettingsEvent((Object)this));
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setBrightness(Integer brightness) {
        this.settings.setBrightness(brightness.intValue());
    }

    public void setSharpen(Float sharpen) {
        this.settings.setSharpen(sharpen.floatValue());
    }

    public void setvStretch(Float vStretch) {
        this.settings.setvStretch(vStretch);
    }

    public void sethStretch(Float hStretch) {
        this.settings.sethStretch(hStretch);
    }

    public void setDiameter(Float diameter) {
        this.settings.setDiameter(diameter);
    }

    public void setCrop(List<Point> points) {
        this.settings.setCrop(points);
    }

    public void setCenter(Point point) {
        this.settings.setCenter(point);
    }
}

