/*
 * Decompiled with CFR 0.152.
 */
package de.filth.service;

import de.filth.domain.ScoringResult;
import de.filth.service.SettingsService;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import nu.pattern.OpenCV;
import org.apache.commons.io.IOUtils;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;
import org.opencv.imgproc.Moments;
import org.opencv.videoio.VideoCapture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ScoringService {
    @Autowired
    private SettingsService settingsService;
    @Value(value="${showGoodFeaturesToTrack}")
    private Boolean showGoodFeaturesToTrack;
    private byte[] abstractTarget;

    public ScoringService() throws InterruptedException, IOException {
        OpenCV.loadShared();
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream is = classloader.getResourceAsStream("static/target_s.jpeg");
        this.abstractTarget = IOUtils.toByteArray((InputStream)is);
    }

    private void getFrame() throws InterruptedException {
        VideoCapture videoCapture = new VideoCapture();
        boolean openStatus = videoCapture.open("rtsp://filthz:123bolsius@192.168.3.200:554/stream2", 1900);
        int i = 0;
        while (true) {
            Mat mat = new Mat();
            videoCapture.read(mat);
            Imgcodecs.imwrite((String)("../" + i + ".png"), (Mat)mat);
            ++i;
        }
    }

    private Point recognizeCenter(Mat mat, Point targetCenter) {
        int maxCorners = 1000;
        MatOfPoint corners = new MatOfPoint();
        double qualityLevel = 0.01;
        double minDistance = 20.0;
        int blockSize = 3;
        int gradientSize = 3;
        boolean useHarrisDetector = false;
        double k = 0.04;
        Mat cpy = mat.clone();
        Imgproc.goodFeaturesToTrack((Mat)cpy, (MatOfPoint)corners, (int)maxCorners, (double)qualityLevel, (double)minDistance, (Mat)new Mat(), (int)blockSize, (int)gradientSize, (boolean)useHarrisDetector, (double)k);
        System.out.println("** Number of corners detected: " + corners.rows());
        ArrayList<Point> relevantPointsX = new ArrayList<Point>();
        ArrayList<Point> relevantPointsY = new ArrayList<Point>();
        int[] cornersData = new int[(int)(corners.total() * (long)corners.channels())];
        corners.get(0, 0, cornersData);
        int radius = 4;
        for (int i = 0; i < corners.rows(); ++i) {
            double deviationY;
            int x = cornersData[i * 2];
            int y = cornersData[i * 2 + 1];
            boolean added = false;
            if (targetCenter == null) continue;
            double deviationX = Math.abs(targetCenter.x - (double)x);
            if (deviationX < 40.0) {
                relevantPointsX.add(new Point((double)x, (double)y));
                added = true;
            }
            if ((deviationY = Math.abs(targetCenter.y - (double)y)) < 40.0) {
                relevantPointsY.add(new Point((double)x, (double)y));
                added = true;
            }
            if (!added || !this.showGoodFeaturesToTrack.booleanValue()) continue;
            Imgproc.circle((Mat)mat, (Point)new Point((double)x, (double)y), (int)radius, (Scalar)new Scalar(0.0, 256.0, 0.0), (int)-1);
        }
        double avgX = 0.0;
        double avgY = 0.0;
        for (Point point : relevantPointsX) {
            avgX += point.x;
        }
        for (Point point : relevantPointsY) {
            avgY += point.y;
        }
        avgY /= (double)relevantPointsY.size();
        if ((avgX /= (double)relevantPointsX.size()) != 0.0 && targetCenter != null) {
            Imgproc.line((Mat)mat, (Point)new Point(avgX, (double)mat.height()), (Point)new Point(avgX, 0.0), (Scalar)new Scalar(0.0, 256.0, 0.0), (int)1);
        }
        if (avgY != 0.0 && targetCenter != null) {
            Imgproc.line((Mat)mat, (Point)new Point((double)mat.width(), avgY), (Point)new Point(0.0, avgY), (Scalar)new Scalar(0.0, 256.0, 0.0), (int)1);
        }
        if (avgX != 0.0 && avgY != 0.0) {
            Point intersection = new Point(avgX, avgY);
            System.out.println("** Number of relevant points x: " + relevantPointsX.size() + " | avgX, avgY: " + avgX + "," + avgY + " | intersection: " + intersection);
            return intersection;
        }
        return null;
    }

    private int getScore(List<Integer> scoreBoundaries, double holeDist) {
        int score = 0;
        if (!scoreBoundaries.isEmpty() && (double)scoreBoundaries.get(0).intValue() > holeDist) {
            score = 10;
        }
        for (int i = 1; i < scoreBoundaries.size(); ++i) {
            if (!((double)scoreBoundaries.get(i - 1).intValue() <= holeDist) || !(holeDist < (double)scoreBoundaries.get(i).intValue())) continue;
            score = scoreBoundaries.size() - i;
        }
        return score;
    }

    private Point centroid(MatOfPoint point) {
        Moments m = Imgproc.moments((Mat)point);
        long cxl = Math.round(m.get_m10() / m.get_m00());
        long cyl = Math.round(m.get_m01() / m.get_m00());
        int cx = (int)cxl;
        int cy = (int)cyl;
        return new Point((double)cx, (double)cy);
    }

    public BufferedImage mat2BufferedImage(Mat matrix) throws Exception {
        MatOfByte mob = new MatOfByte();
        Imgcodecs.imencode((String)".jpg", (Mat)matrix, (MatOfByte)mob);
        byte[] ba = mob.toArray();
        return ImageIO.read(new ByteArrayInputStream(ba));
    }

    private void increase_brightness(Mat img, int value) {
        img.convertTo(img, -1, 1.0, (double)value);
    }

    private void increase_contrast(Mat img, int value) {
        img.convertTo(img, -1, 1.0, 0.0);
    }

    private Mat sharpen(Mat img, float value) {
        Mat dest = new Mat(img.rows(), img.cols(), img.type());
        Imgproc.GaussianBlur((Mat)img, (Mat)dest, (Size)new Size(0.0, 0.0), (double)value);
        Core.addWeighted((Mat)img, (double)1.5, (Mat)dest, (double)-0.5, (double)0.0, (Mat)dest);
        return dest;
    }

    private byte[] getAbstractTargetWithHits(List<Point> hits, int widthFrame, int heightFrame) {
        Mat mat = Imgcodecs.imdecode((Mat)new MatOfByte(this.abstractTarget), (int)-1);
        int widthAbstract = mat.width();
        int heightAbsctract = mat.height();
        int offsetX = 30;
        int offsetY = 20;
        for (Point point : hits) {
            double ratioX = (double)widthFrame / point.x;
            double ratioY = (double)heightFrame / point.y;
            Point abstractPoint = new Point((double)widthAbstract / ratioX + (double)offsetX, (double)heightAbsctract / ratioY + (double)offsetY);
            Imgproc.circle((Mat)mat, (Point)abstractPoint, (int)10, (Scalar)new Scalar(0.0, 0.0, 255.0), (int)-1);
        }
        MatOfByte mob = new MatOfByte();
        Imgcodecs.imencode((String)".jpg", (Mat)mat, (MatOfByte)mob);
        return mob.toArray();
    }

    public void test() {
        Mat img0 = Imgcodecs.imread((String)"/tmp/xxx1.png");
        Mat img1 = Imgcodecs.imread((String)"/tmp/xxx1.png", (int)0);
        Mat img2 = Imgcodecs.imread((String)"/tmp/xxx2.png", (int)0);
        Mat ma5 = new Mat();
        Core.absdiff((Mat)img1, (Mat)img2, (Mat)ma5);
        Imgproc.threshold((Mat)ma5, (Mat)ma5, (double)127.0, (double)255.0, (int)0);
        ArrayList points3 = new ArrayList();
        Imgproc.findContours((Mat)ma5, points3, (Mat)new Mat(), (int)0, (int)2);
        for (MatOfPoint c : points3) {
            double contourArea = Imgproc.contourArea((Mat)c);
            if (contourArea <= 100.0) continue;
            Rect rect = Imgproc.boundingRect((Mat)c);
            Imgproc.circle((Mat)img0, (Point)new Point((double)rect.x, (double)rect.y), (int)10, (Scalar)new Scalar(0.0, 0.0, 255.0), (int)-1);
        }
        Imgcodecs.imwrite((String)"/tmp/xxx.png", (Mat)img0);
    }

    public ScoringResult getScoringResult(byte[] imageBytes) {
        Float diameter;
        Mat mat = Imgcodecs.imdecode((Mat)new MatOfByte(imageBytes), (int)-1);
        List crop = this.settingsService.getSettings().getCrop();
        if (!crop.isEmpty()) {
            MatOfPoint2f src = new MatOfPoint2f(new Point[]{(Point)crop.get(0), (Point)crop.get(1), (Point)crop.get(2), (Point)crop.get(3)});
            double x2 = ((Point)crop.get((int)1)).x;
            MatOfPoint2f dst2 = new MatOfPoint2f(new Point[]{new Point(0.0, 0.0), new Point(x2, 0.0), new Point(0.0, x2), new Point(x2, x2)});
            Mat perspectiveTransform = Imgproc.getPerspectiveTransform((Mat)src, (Mat)dst2);
            Imgproc.warpPerspective((Mat)mat, (Mat)mat, (Mat)perspectiveTransform, (Size)new Size(x2, x2));
        }
        Float vStretch = this.settingsService.getSettings().getvStretch();
        Float hStretch = this.settingsService.getSettings().gethStretch();
        if (vStretch != null || hStretch != null) {
            hStretch = Float.valueOf(hStretch != null ? hStretch.floatValue() : (float)mat.width());
            vStretch = Float.valueOf(vStretch != null ? vStretch.floatValue() : (float)mat.height());
            Imgproc.resize((Mat)mat, (Mat)mat, (Size)new Size((double)hStretch.floatValue(), (double)vStretch.floatValue()), (double)1.0);
        }
        Point targetCenter = null;
        this.increase_brightness(mat, this.settingsService.getSettings().getBrightness());
        this.increase_contrast(mat, 0);
        mat = this.sharpen(mat, this.settingsService.getSettings().getSharpen());
        ArrayList dst = new ArrayList(3);
        Core.split((Mat)mat, dst);
        Mat h_mask = new Mat();
        Core.inRange((Mat)((Mat)dst.get(0)), (Scalar)new Scalar(0.0), (Scalar)new Scalar(50.0), (Mat)h_mask);
        ArrayList points3 = new ArrayList();
        Imgproc.findContours((Mat)h_mask, points3, (Mat)new Mat(), (int)0, (int)2);
        ArrayList<Integer> scoreboundaries = new ArrayList<Integer>();
        if (targetCenter != null) {
            Imgproc.circle((Mat)mat, targetCenter, (int)2, (Scalar)new Scalar(255.0, 0.0, 0.0), (int)5);
        }
        if ((diameter = this.settingsService.getSettings().getDiameter()) != null && targetCenter != null) {
            for (int i = 1; i <= 12; ++i) {
                Imgproc.circle((Mat)mat, targetCenter, (int)(i * diameter.intValue()), (Scalar)new Scalar(255.0, 0.0, 0.0), (int)1);
                scoreboundaries.add(i * diameter.intValue());
            }
        }
        ArrayList<Point> hits = new ArrayList<Point>();
        ArrayList<Double> holeDists = new ArrayList<Double>();
        for (MatOfPoint c : points3) {
            double contourArea = Imgproc.contourArea((Mat)c);
            if (contourArea <= 40.0 || contourArea > 510.0) continue;
            Rect rect = Imgproc.boundingRect((Mat)c);
            ArrayList<Point> pts = new ArrayList<Point>();
            pts.add(new Point((double)rect.x, (double)rect.y));
            pts.add(new Point((double)(rect.x + rect.width), (double)rect.y));
            pts.add(new Point((double)rect.x, (double)(rect.y + rect.height)));
            pts.add(new Point((double)(rect.x + rect.width), (double)(rect.y + rect.height)));
            Point centerHole = this.centroid(c);
            pts.add(centerHole);
            int pointScore = 0;
            for (Point point : pts) {
                double x = point.x;
                double y = point.y;
                if (targetCenter == null) continue;
                double holeDist = Math.sqrt(Math.pow(x - targetCenter.x, 2.0) + Math.pow(y - targetCenter.y, 2.0));
                holeDists.add(holeDist);
                int score = this.getScore(scoreboundaries, holeDist);
                if (score <= pointScore) continue;
                pointScore = score;
            }
            if (rect.width < 10 || rect.width > 40) {
                // empty if block
            }
            if (pointScore == 0) continue;
            hits.add(centerHole);
            Imgproc.circle((Mat)mat, (Point)centerHole, (int)1, (Scalar)new Scalar(0.0, 0.0, 255.0), (int)-1);
            Imgproc.drawContours((Mat)mat, Collections.singletonList(c), (int)-1, (Scalar)new Scalar(0.0, 255.0, 0.0), (int)1);
            Imgproc.putText((Mat)mat, (String)("Score: " + pointScore), (Point)new Point(centerHole.x - 20.0, centerHole.y + 20.0), (int)3, (double)0.5, (Scalar)new Scalar(0.0, 0.0, 255.0), (int)1);
        }
        MatOfByte mob = new MatOfByte();
        Imgcodecs.imencode((String)".jpg", (Mat)mat, (MatOfByte)mob);
        byte[] imageArr = mob.toArray();
        ScoringResult scoringResult = new ScoringResult();
        scoringResult.setImage(imageArr);
        scoringResult.setHits(hits);
        scoringResult.setAbstractImage(this.getAbstractTargetWithHits(hits, mat.width(), mat.height()));
        return scoringResult;
    }
}

