/*
 * Decompiled with CFR 0.152.
 */
package de.filth.service;

import de.filth.domain.Images;
import de.filth.domain.ScoringResult;
import de.filth.service.ScoringService;
import de.filth.service.SettingsService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.net.util.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PictureService {
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private ScoringService scoringService;
    private String tmpDir = System.getProperty("java.io.tmpdir");
    private String camFile = this.tmpDir + File.separator + "screen.png";

    @PostConstruct
    public void storeImage() {
        String prefix = "C:\\Users\\filth\\Downloads\\ffmpeg-master-latest-win64-gpl\\bin\\";
        String command = prefix + "ffmpeg.exe -y -i rtsp://filthz:123bolsius@192.168.3.200:554/stream1 -vframes 1 " + this.camFile;
        new Thread(() -> {
            try {
                while (true) {
                    Process process = Runtime.getRuntime().exec(command);
                    process.waitFor();
                    Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).start();
    }

    public byte[] getUnprocessedImage() throws IOException {
        File file = new File(this.camFile);
        if (!file.exists()) {
            return new byte[0];
        }
        return Files.readAllBytes(file.toPath());
    }

    public Images getBase64ProcessedImages() throws IOException {
        Images images = new Images();
        Base64 base64 = new Base64();
        byte[] bytes = this.getUnprocessedImage();
        if (bytes.length == 0) {
            return images;
        }
        ScoringResult scoringResult = this.scoringService.getScoringResult(bytes);
        String encodedRaw = new String(base64.encode(scoringResult.getImage()));
        String encodedAbstract = new String(base64.encode(scoringResult.getAbstractImage()));
        images.setRawImage("data:image/png;base64, " + encodedRaw);
        images.setAbstractImage("data:image/png;base64, " + encodedAbstract);
        return images;
    }
}

