/*
 * Decompiled with CFR 0.152.
 */
package de.filth.controller;

import de.filth.domain.Images;
import de.filth.domain.SettingsEvent;
import de.filth.service.PictureService;
import java.io.IOException;
import java.util.Map;
import java.util.zip.CRC32;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IndexController
implements ApplicationListener<SettingsEvent> {
    @Autowired
    private PictureService pictureService;
    @Autowired
    private SimpMessagingTemplate simpMessagingTemplate;
    private String imageCRC = "";

    @PostConstruct
    public void init() throws IOException {
        try {
            this.imageChanged();
        }
        catch (Exception e) {
            System.out.println("x");
        }
    }

    @RequestMapping(value={"/image"}, method={RequestMethod.GET})
    public ResponseEntity getimage() throws IOException {
        Images images = this.pictureService.getBase64ProcessedImages();
        return new ResponseEntity((Object)images, HttpStatus.OK);
    }

    @RequestMapping(value={"/crcchanged"}, method={RequestMethod.GET})
    public ResponseEntity imageChanged() throws IOException {
        byte[] bytes = this.pictureService.getUnprocessedImage();
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        String crc = String.valueOf(crc32.getValue());
        if (this.imageCRC == null || !this.imageCRC.equalsIgnoreCase(crc)) {
            this.imageCRC = crc;
            return new ResponseEntity((Object)true, HttpStatus.OK);
        }
        return new ResponseEntity((Object)false, HttpStatus.OK);
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public ModelAndView index(ModelMap model) throws IOException {
        byte[] bytes = this.pictureService.getUnprocessedImage();
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        Images images = this.pictureService.getBase64ProcessedImages();
        model.addAttribute("img", (Object)images.getRawImage());
        model.addAttribute("imgAbstract", (Object)images.getAbstractImage());
        return new ModelAndView("index", (Map)model);
    }

    public void onApplicationEvent(SettingsEvent settingsEvent) {
        try {
            Images images = this.pictureService.getBase64ProcessedImages();
            this.simpMessagingTemplate.convertAndSend((Object)"/topic/image", (Object)images);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

