/*
 * Decompiled with CFR 0.152.
 */
package de.filth.service;

import com.google.gson.Gson;
import de.filth.domain.Command;
import de.filth.util.CommandService;
import java.util.UUID;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class MqttService {
    private String mqttUser = "segmentwatch";
    private String mqttPassword = "magic";
    private IMqttClient mqttClient;
    private String mqttBroker = "broker1.fact0rn.wtf:5883";
    public static String MASTER_COMMAND = "master/command";
    private boolean testMode = false;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    @Order(value=1)
    @EventListener(value={ApplicationReadyEvent.class})
    public void init() throws MqttException {
        try {
            this.establishConnection();
        }
        catch (Exception e) {
            this.LOG.error("Failed to connect. Retrying...", (Throwable)e);
            this.establishConnection();
            System.exit(0);
        }
    }

    private void establishConnection() throws MqttException {
        String mqttAddress = "tcp://" + this.mqttBroker + ":2883";
        if (!(this.mqttClient != null && this.mqttClient.isConnected() || StringUtils.isEmpty((Object)mqttAddress))) {
            String publisherId = "segmentwatch--" + String.valueOf(UUID.randomUUID());
            this.mqttClient = new MqttClient(mqttAddress, publisherId, (MqttClientPersistence)new MemoryPersistence());
            this.mqttClient.setCallback((MqttCallback)new /* Unavailable Anonymous Inner Class!! */);
            MqttConnectOptions options = new MqttConnectOptions();
            options.setAutomaticReconnect(true);
            options.setCleanSession(true);
            options.setConnectionTimeout(120);
            options.setUserName(this.mqttUser);
            options.setPassword(this.mqttPassword.toCharArray());
            options.setMaxReconnectDelay(60);
            this.mqttClient.connect(options);
            this.LOG.info("Connected to mqtt broker");
        }
    }

    public void processMessage(String topic, MqttMessage message) {
        if (topic.equalsIgnoreCase(MASTER_COMMAND)) {
            Command command = (Command)new Gson().fromJson(new String(message.getPayload()), Command.class);
            if (!command.getCommand().equalsIgnoreCase("restart_segment")) {
                return;
            }
            String segNum = (String)command.getDetails().get(0);
            String pubKey = (String)command.getDetails().get(1);
            this.LOG.info("Received command to restart segment {} with pubkey {}", (Object)segNum, (Object)pubKey);
            String execute = CommandService.execute((String)("screen -S segment" + segNum + " -X quit"));
            this.LOG.info("Stopped segment. Result: {}", (Object)execute);
            String execute1 = CommandService.execute((String)("runsegment.sh " + segNum + " " + pubKey));
            this.LOG.info("Started segment. Result: {}", (Object)execute1);
            return;
        }
    }
}

